<?php
/****************************************************
 * Daftar Kehadiran  versi sederhana (fixed)
 * Tabel: kehadiran (nama, wa, gereja, scan_time)
 ****************************************************/

// ============ KONFIGURASI DB ============
$DB_HOST = "localhost";
$DB_USER = "scac8254_tes";
$DB_PASS = "scac8254_tes";
$DB_NAME = "scac8254_tes";

date_default_timezone_set('Asia/Jakarta');

// Koneksi
$mysqli = @new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);
if ($mysqli->connect_error) {
  http_response_code(500);
  die("Koneksi database gagal: " . htmlspecialchars($mysqli->connect_error));
}
$mysqli->set_charset("utf8mb4");

// Ambil total & data
$totalRows = 0;
$resCount = $mysqli->query("SELECT COUNT(*) AS total FROM kehadiran");
if ($resCount) { $row = $resCount->fetch_assoc(); $totalRows = (int)($row['total'] ?? 0); $resCount->close(); }

$sql = "SELECT nama, wa, gereja, scan_time FROM kehadiran ORDER BY scan_time DESC";
$res = $mysqli->query($sql);
$rows = [];
if ($res) { while ($r = $res->fetch_assoc()) $rows[] = $r; $res->close(); }

// ===== Export Excel =====
if (isset($_GET['export']) && $_GET['export'] === 'xls') {
  $filename = "kehadiran_" . date("Ymd_His") . ".xls";
  if (ob_get_length()) { ob_end_clean(); }
  header("Content-Type: application/vnd.ms-excel; charset=UTF-8");
  header("Content-Disposition: attachment; filename=\"{$filename}\"");
  header("X-Content-Type-Options: nosniff");

  echo "<html><head><meta charset=\"UTF-8\"></head><body>";
  echo "<table border='1' cellspacing='0' cellpadding='6'>";
  echo "<tr style='font-weight:bold;background:#eaeaea'><td>Nama</td><td>WA</td><td>Gereja</td><td>Waktu</td></tr>";
  foreach ($rows as $r) {
    $nama   = htmlspecialchars($r['nama'] ?? '');
    $wa     = htmlspecialchars($r['wa'] ?? '');
    $gereja = htmlspecialchars($r['gereja'] ?? '');
    $waktu  = isset($r['scan_time']) ? htmlspecialchars(date('H:i', strtotime($r['scan_time'])) . ' WIB') : '';
    echo "<tr><td>{$nama}</td><td>{$wa}</td><td>{$gereja}</td><td>{$waktu}</td></tr>";
  }
  echo "</table>";
  echo "</body></html>";
  $mysqli->close();
  exit;
}

function esc($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
?>
<!DOCTYPE html><html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>By SCARD-PROJECT</title>
  <link rel="icon" href="asecet/icon.png" type="image/x-icon">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- AOS -->
  <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800;900&display=swap');

    body {
      font-family: 'Poppins', sans-serif;
      background: conic-gradient(from -45deg, #ca49f7, #5a8ade, #62c6e0, #ca49f7);
      padding: 10px;
      display: flex;
      flex-direction: column;
      min-height: 100vh;
      margin: 0;
      overflow-x: hidden;
      color: #fff; /* teks putih global */
    }

    /* Overlay */
    .overlay { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.35); opacity: 0; visibility: hidden; transition: opacity 0.35s ease; z-index: 1000; }
    .overlay.active { opacity: 1; visibility: visible; }

    /* Sidebar */
    .sidebar {
      position: fixed; top: 0; left: 0; width: 270px; height: 100vh;
      background: rgba(255,255,255,0.12); backdrop-filter: blur(20px);
      color: white; padding-top: 70px; z-index: 1100;
      border-top-right-radius: 30px; border-bottom-right-radius: 30px;
      box-shadow: 4px 0 20px rgba(0,0,0,0.25);
      transform: translateX(-100%); transition: transform 0.35s cubic-bezier(0.25, 1, 0.3, 1);
    }
    .sidebar.active { transform: translateX(0); }
    .sidebar ul { list-style: none; padding: 0; margin: 0; }
    .sidebar ul li a { display: flex; align-items: center; padding: 14px 20px; margin: 6px 12px; border-radius: 12px; color: white; text-decoration: none; font-size: 16px; }
    .sidebar ul li a:hover { background: rgba(255,255,255,0.25); }
    .sidebar ul li a.active { background: rgba(0,123,255,0.35); box-shadow: inset 0 0 8px rgba(0,123,255,0.6); }
    .sidebar ul li i { margin-right: 14px; font-size: 20px; width: 25px; text-align: center; }

    /* Navbar */
    #navbar-top { position: sticky; top: 10px; z-index: 999; }
    .menu-btn { font-size: 24px; cursor: pointer; margin-right: 15px; color: #fff; }

    /* Konten */
    .glass-card {
      backdrop-filter: blur(20px);
      background: rgba(255, 255, 255, 0.18);
      border-radius: 20px;
      padding: 22px;
      max-width: 420px;
      width: 100%;
      color: #fff;
      box-shadow: 0 8px 24px rgba(0,0,0,0.15);
      margin: 20px auto;
    }
    h2 { text-align: center; font-size: 20px; margin-bottom: 6px; font-weight: 600; color: #fff; }
    .owner { text-align: center; font-size: 14px; color: #eee; margin-bottom: 20px; }

    .account {
      background: rgba(255,255,255,0.1);
      padding: 14px 16px; border-radius: 14px; margin-bottom: 14px;
      display: flex; justify-content: space-between; align-items: center;
      box-shadow: inset 0 0 6px rgba(0,0,0,0.05); color:#fff;
    }
    .label { font-size: 13px; font-weight: 500; color: #f0f0f0; margin-bottom: 2px; }
    .number { font-size: 16px; font-weight: 600; color: #fff; letter-spacing: 0.5px; }

    .copy-btn { background: rgba(255,255,255,0.12); border: 1px solid rgba(255,255,255,0.25); border-radius: 8px; cursor: pointer; font-size: 16px; padding: 6px 10px; color: #fff; transition: all 0.25s ease; }
    .copy-btn:hover { background: rgba(255,255,255,0.22); }

    .upload-box { text-align: center; margin-top: 15px; padding: 15px; background: rgba(255,255,255,0.1); border-radius: 14px; cursor: pointer; border: 2px dashed rgba(255,255,255,0.25); transition: all 0.25s ease; font-size: 14px; color: #fff; }
    .upload-box:hover { background: rgba(255,255,255,0.2); }
    .upload-box input { display: none; }
    .preview-img { max-width: 100%; margin-top: 10px; border-radius: 12px; display: none; }

    textarea {
      width: 100%; margin-top: 12px; padding: 12px; border-radius: 12px;
      border: 1px solid rgba(255,255,255,0.25); resize: none;
      font-family: inherit; font-size: 14px; background: rgba(255,255,255,0.1); color:#fff;
    }
    textarea:focus { border: 1px solid rgba(255,255,255,0.5); outline: none; }

    button.send {
      margin-top: 15px; width: 100%; padding: 14px; border: none; border-radius: 12px;
      background: linear-gradient(135deg, rgba(255,255,255,0.25), rgba(255,255,255,0.15));
      color: white; font-size: 16px; font-weight: 500; cursor: pointer;
      box-shadow: 0 4px 12px rgba(0,0,0,0.3); transition: all 0.3s ease;
    }
    button.send:hover { background: linear-gradient(135deg, rgba(255,255,255,0.35), rgba(255,255,255,0.2)); box-shadow: 0 6px 16px rgba(0,0,0,0.4); }

    /* Area Daftar Kehadiran  INI YANG TADI HITAM */
    .card{
      max-width:1100px;margin:auto;
      background: rgba(255,255,255,0.15);   /* <-- transparan (bukan #222) */
      color:#fff;
      padding:20px;border-radius:14px;
      border:1px solid rgba(255,255,255,0.3);
      backdrop-filter: blur(18px);
    }
    .topbar{display:flex;justify-content:space-between;align-items:center;margin-bottom:12px;gap:16px}
    .brand{display:flex;align-items:center;gap:12px}
    .logo{width:40px;height:40px;border-radius:12px;background:linear-gradient(135deg,#a259ff,#ff2e92);display:grid;place-items:center;font-weight:800;color:#fff}
    .title{font-weight:800;font-size:clamp(18px,2.6vw,24px);color:#fff}
    .muted{color:#f2f2f2b3;font-size:13px}
    .btn{appearance:none;border-radius:12px;border:1px solid rgba(255,255,255,.4);background:rgba(255,255,255,.2);padding:10px 14px;color:#fff;font-weight:700;cursor:pointer;text-decoration:none}
    .btn:hover{background:rgba(255,255,255,.3)}
    .stats{display:flex;align-items:center;gap:10px}

    table{width:100%; border-collapse:separate; border-spacing:0 10px; color:#fff}
    thead th{font-size:13px;color:#fff;text-align:left;padding:6px 10px}
    tbody tr{background:rgba(255,255,255,.12); border:1px solid rgba(255,255,255,.25)}  /* <-- baris jadi glass */
    tbody td{padding:10px 12px; border-top:1px solid rgba(255,255,255,.25); border-bottom:1px solid rgba(255,255,255,.25)}
    tbody tr:first-child td{border-top-left-radius:12px;border-top-right-radius:12px}
    tbody tr:last-child td{border-bottom-left-radius:12px;border-bottom-right-radius:12px}
    .w{white-space:nowrap}
  </style>
</head>
<body>

<!-- Overlay -->
<div class="overlay" id="overlay"></div>

<!-- Sidebar -->
<div class="sidebar" id="sidebar">
  <ul>
    <li><a href="../siap/index"><i class="fas fa-th-large"></i> Daftar Hadir</a></li>
    <li><a href="../siap/daftar" class="active"><i class="fa-brands fa-github"></i> Data Register</a></li>
    <li><a href="../siap/scan"><i class="fa-solid fa-lock"></i> Scan qrcode</a></li>
    <li><a href="../siap/register"><i class="fa-solid fa-gear"></i> Katalog New daftar </a></li>
    
  </ul>
</div>

<!-- Navbar Top -->
<div id="navbar-top" class="d-flex align-items-center mb-3">
  <span class="menu-btn" id="menu-btn"><i class="fas fa-bars"></i></span>
  <h5 class="text-white m-0">Admin youth Natal</h5>
</div>

<!-- Main Content -->
<div class="glass-card">
  <div class="card">
    <div class="topbar">
      <div class="brand">
        <div class="logo">QR</div>
        <div>
          <div class="title">Daftar Kehadiran</div>
          <div class="muted">Daftar hadir (nama  wa  gereja  waktu)</div>
        </div>
      </div>
      <div class="stats">
        <div class="muted">Total peserta:</div>
        <div style="font-weight:800"><?=esc($totalRows)?></div>
        <a class="btn" href="?export=xls" title="Download Excel">Download Excel</a>
      </div>
    </div>

    <div style="overflow:auto">
      <table>
        <thead>
          <tr>
            <th>Nama</th>
            <th>WA</th>
            <th>Gereja</th>
            <th class="w">Waktu</th>
          </tr>
        </thead>
        <tbody>
          <?php if (!$rows): ?>
            <tr><td colspan="4" style="padding:14px 12px">Belum ada data.</td></tr>
          <?php else: foreach ($rows as $r): ?>
            <tr>
              <td><?=esc($r['nama'])?></td>
              <td class="w"><?=esc($r['wa'])?></td>
              <td><?=esc($r['gereja'])?></td>
              <td class="w"><?php
                $raw = $r['scan_time'] ?? '';
                echo $raw ? esc(date('H:i', strtotime($raw)) . ' WIB') : '';
              ?></td>
            </tr>
          <?php endforeach; endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<footer style="text-align:center;color:#fff;padding:10px 0;">
   2025 SCARD-PROJECT
</footer>

<!-- Script -->
<script>
  const menuBtn = document.getElementById('menu-btn');
  const sidebar = document.getElementById('sidebar');
  const overlay = document.getElementById('overlay');

  menuBtn.addEventListener('click', () => {
    sidebar.classList.toggle('active');
    overlay.classList.toggle('active');
  });

  overlay.addEventListener('click', () => {
    sidebar.classList.remove('active');
    overlay.classList.remove('active');
  });

  function copyText(id) {
    const el = document.getElementById(id);
    const text = el ? el.innerText : '';
    if (!text) return;
    navigator.clipboard.writeText(text).then(() => {
      alert('Teks disalin: ' + text);
    });
  }
</script>
</body>
</html>
<?php $mysqli->close(); ?>